/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings;

import com.tristankechlo.livingthings.entity.AncientBlazeEntity;
import com.tristankechlo.livingthings.entity.BabyEnderDragonEntity;
import com.tristankechlo.livingthings.entity.CrabEntity;
import com.tristankechlo.livingthings.entity.ElephantEntity;
import com.tristankechlo.livingthings.entity.FlamingoEntity;
import com.tristankechlo.livingthings.entity.GiraffeEntity;
import com.tristankechlo.livingthings.entity.KoalaEntity;
import com.tristankechlo.livingthings.entity.LionEntity;
import com.tristankechlo.livingthings.entity.MantarayEntity;
import com.tristankechlo.livingthings.entity.MonkeyEntity;
import com.tristankechlo.livingthings.entity.NetherKnightEntity;
import com.tristankechlo.livingthings.entity.OstrichEntity;
import com.tristankechlo.livingthings.entity.OwlEntity;
import com.tristankechlo.livingthings.entity.PeacockEntity;
import com.tristankechlo.livingthings.entity.PenguinEntity;
import com.tristankechlo.livingthings.entity.RaccoonEntity;
import com.tristankechlo.livingthings.entity.SeahorseEntity;
import com.tristankechlo.livingthings.entity.SharkEntity;
import com.tristankechlo.livingthings.entity.ShroomieEntity;
import com.tristankechlo.livingthings.entity.SnailEntity;
import com.tristankechlo.livingthings.entity.projectile.ThrownOstrichEgg;
import com.tristankechlo.livingthings.init.ModBlocks;
import com.tristankechlo.livingthings.init.ModCreativeTabs;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.mixin.SpawnPlacementsInvoker;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LivingThings {
    public static final String MOD_ID = "livingthings";
    public static final String MOD_NAME = "Living Things";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Living Things");

    public static void init() {
        ModItems.init();
        ModBlocks.init();
        ModSounds.init();
        ModEntityTypes.init();
        ModCreativeTabs.init();
    }

    public static void registerMobAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> consumer) {
        LOGGER.info("Registering MobAttributes");
        consumer.accept(ModEntityTypes.ELEPHANT.get(), ElephantEntity.createAttributes());
        consumer.accept(ModEntityTypes.GIRAFFE.get(), GiraffeEntity.createAttributes());
        consumer.accept(ModEntityTypes.LION.get(), LionEntity.createAttributes());
        consumer.accept(ModEntityTypes.SHARK.get(), SharkEntity.createAttributes());
        consumer.accept(ModEntityTypes.PENGUIN.get(), PenguinEntity.createAttributes());
        consumer.accept(ModEntityTypes.OSTRICH.get(), OstrichEntity.createAttributes());
        consumer.accept(ModEntityTypes.FLAMINGO.get(), FlamingoEntity.createAttributes());
        consumer.accept(ModEntityTypes.CRAB.get(), CrabEntity.createAttributes());
        consumer.accept(ModEntityTypes.MANTARAY.get(), MantarayEntity.m_27495_());
        consumer.accept(ModEntityTypes.RACCOON.get(), RaccoonEntity.createAttributes());
        consumer.accept(ModEntityTypes.OWL.get(), OwlEntity.createAttributes());
        consumer.accept(ModEntityTypes.ANCIENT_BLAZE.get(), AncientBlazeEntity.createAttributes());
        consumer.accept(ModEntityTypes.KOALA.get(), KoalaEntity.createAttributes());
        consumer.accept(ModEntityTypes.SNAIL.get(), SnailEntity.createAttributes());
        consumer.accept(ModEntityTypes.MONKEY.get(), MonkeyEntity.createAttributes());
        consumer.accept(ModEntityTypes.NETHER_KNIGHT.get(), NetherKnightEntity.createAttributes());
        consumer.accept(ModEntityTypes.SHROOMIE.get(), ShroomieEntity.createAttributes());
        consumer.accept(ModEntityTypes.SEAHORSE.get(), SeahorseEntity.m_27495_());
        consumer.accept(ModEntityTypes.BABY_ENDER_DRAGON.get(), BabyEnderDragonEntity.createAttributes());
        consumer.accept(ModEntityTypes.PEACOCK.get(), PeacockEntity.createAttributes());
    }

    public static void registerSpawnPlacements() {
        LOGGER.info("Registering SpawnPlacements");
        SpawnPlacementsInvoker.register(ModEntityTypes.ELEPHANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ElephantEntity::checkElephantSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.GIRAFFE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GiraffeEntity::checkGiraffeSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.LION.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LionEntity::checkLionSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.SHARK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SharkEntity::checkSharkSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.PENGUIN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PenguinEntity::checkPenguinSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.OSTRICH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OstrichEntity::checkOstrichSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.FLAMINGO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlamingoEntity::checkFlamingoSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.CRAB.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrabEntity::checkCrabSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.MANTARAY.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MantarayEntity::checkMantaraySpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.RACCOON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RaccoonEntity::checkRaccoonSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.OWL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, OwlEntity::checkOwlSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.ANCIENT_BLAZE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnPlacementsInvoker.register(ModEntityTypes.KOALA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, KoalaEntity::checkKoalaSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.SNAIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SnailEntity::checkSnailSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.MONKEY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, MonkeyEntity::checkMonkeySpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.NETHER_KNIGHT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnPlacementsInvoker.register(ModEntityTypes.SHROOMIE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ShroomieEntity::checkShroomieSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.SEAHORSE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SeahorseEntity::checkSeahorseSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.BABY_ENDER_DRAGON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BabyEnderDragonEntity::checkBabyEnderDragonSpawnRules);
        SpawnPlacementsInvoker.register(ModEntityTypes.PEACOCK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PeacockEntity::checkPeacockSpawnRules);
    }

    public static void registerDispenserBehavior() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.OSTRICH_EGG.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level world, Position pos, ItemStack stack) {
                return (Projectile)Util.m_137469_((Object)((Object)new ThrownOstrichEgg(world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_())), egg -> egg.m_37446_(stack));
            }
        });
    }
}

